/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import com.xiangcao.xiangcaomengjia.SellingBinSDMValues;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class SellingBinConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CONFIG_FILE_NAME = "trades.json";
    private static SellingBinConfig instance;
    private final Map<String, TradeRule> tradeRules = new HashMap<String, TradeRule>();
    private final Map<String, BinSettings> settings = new HashMap<String, BinSettings>();
    private Path configPath;

    public static SellingBinConfig getInstance() {
        if (instance == null) {
            instance = new SellingBinConfig();
        }
        return instance;
    }

    private SellingBinConfig() {
        this.loadConfig();
    }

    public Path getConfigPath() {
        if (this.configPath != null) {
            return this.configPath;
        }
        Path dir = FMLPaths.CONFIGDIR.get().resolve("xiangcaomengjia");
        this.configPath = dir.resolve(CONFIG_FILE_NAME);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.configPath;
    }

    public void reloadConfig() {
        this.tradeRules.clear();
        this.configPath = null;
        this.loadConfig();
    }

    public List<TradeRule> getTradeRules() {
        return new ArrayList<TradeRule>(this.tradeRules.values());
    }

    public void addRule(String itemId, int inputCount, long price) {
        this.tradeRules.put(itemId, new TradeRule(itemId, inputCount, itemId, 1, price));
    }

    public void addRule(TradeRule rule) {
        this.tradeRules.put(rule.inputItem, rule);
    }

    public void removeRule(String itemId) {
        this.tradeRules.remove(itemId);
    }

    public boolean saveToFile() {
        Path path = this.getConfigPath();
        try {
            JsonObject root = new JsonObject();
            JsonArray arr = new JsonArray();
            for (TradeRule r : this.tradeRules.values()) {
                JsonObject o = new JsonObject();
                o.add("item", (JsonElement)new JsonPrimitive(r.inputItem));
                o.add("count", (JsonElement)new JsonPrimitive((Number)r.inputCount));
                o.add("price", (JsonElement)new JsonPrimitive((Number)r.sdmValue));
                arr.add((JsonElement)o);
            }
            root.add("trades", (JsonElement)arr);
            Files.writeString(path, (CharSequence)root.toString(), new OpenOption[0]);
            LOGGER.info("saved {} trades to {}", (Object)this.tradeRules.size(), (Object)path);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("save trades.json failed", (Throwable)e);
            return false;
        }
    }

    private void loadConfig() {
        Path dir = FMLPaths.CONFIGDIR.get().resolve("xiangcaomengjia");
        this.configPath = dir.resolve(CONFIG_FILE_NAME);
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            LOGGER.warn("\u672a\u627e\u5230 {}\uff0c\u8bf7\u653e\u5728 config/xiangcaomengjia/ \u4e0b", (Object)CONFIG_FILE_NAME);
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            String jsonContent = Files.readString(this.configPath);
            JsonObject root = JsonParser.parseString((String)jsonContent).getAsJsonObject();
            if (root.has("settings")) {
                JsonObject settingsObj = root.getAsJsonObject("settings");
                for (Map.Entry entry : settingsObj.entrySet()) {
                    String tier = (String)entry.getKey();
                    JsonObject tierObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    int updateDelay = tierObj.has("updateDelayTicks") ? tierObj.get("updateDelayTicks").getAsInt() : 200;
                    int inventoryRows = tierObj.has("inventoryRows") ? tierObj.get("inventoryRows").getAsInt() : 1;
                    this.settings.put(tier, new BinSettings(updateDelay, inventoryRows));
                }
            }
            if (root.has("trades")) {
                JsonArray tradesArray = root.getAsJsonArray("trades");
                for (JsonElement tradeElement : tradesArray) {
                    JsonObject tradeObj = tradeElement.getAsJsonObject();
                    if (tradeObj.has("item") && tradeObj.has("price")) {
                        String inputItem = tradeObj.get("item").getAsString();
                        int inputCount = tradeObj.has("count") ? tradeObj.get("count").getAsInt() : 1;
                        long sdmValue = tradeObj.get("price").getAsLong();
                        this.tradeRules.put(inputItem, new TradeRule(inputItem, inputCount, inputItem, 1, sdmValue));
                        continue;
                    }
                    if (!tradeObj.has("input") || !tradeObj.has("output")) continue;
                    JsonObject inputObj = tradeObj.getAsJsonObject("input");
                    JsonObject outputObj = tradeObj.getAsJsonObject("output");
                    String inputItem = inputObj.get("filter").getAsString();
                    int inputCount = inputObj.has("count") ? inputObj.get("count").getAsInt() : 1;
                    String outputItem = outputObj.get("item").getAsString();
                    int outputCount = outputObj.has("count") ? outputObj.get("count").getAsInt() : 1;
                    long sdmValue = SellingBinSDMValues.getValuePerItem(outputItem) * (long)outputCount;
                    this.tradeRules.put(inputItem, new TradeRule(inputItem, inputCount, outputItem, outputCount, sdmValue));
                }
            }
            LOGGER.info("loaded {} trades", (Object)this.tradeRules.size());
        }
        catch (IOException e) {
            LOGGER.error("read trades.json failed", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("parse trades.json failed", (Throwable)e);
        }
    }

    public TradeRule findTrade(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return null;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return null;
        }
        String itemKey = itemId.toString();
        TradeRule rule = this.tradeRules.get(itemKey);
        if (rule != null && stack.m_41613_() >= rule.inputCount) {
            return rule;
        }
        return null;
    }

    public Set<String> getAllSellableItemIds() {
        return new HashSet<String>(this.tradeRules.keySet());
    }

    public BinSettings getSettings(String tier) {
        return this.settings.getOrDefault(tier, new BinSettings(200, 1));
    }

    public static class TradeRule {
        public final String inputItem;
        public final int inputCount;
        public final String outputItem;
        public final int outputCount;
        public final long sdmValue;

        public TradeRule(String inputItem, int inputCount, String outputItem, int outputCount, long sdmValue) {
            this.inputItem = inputItem;
            this.inputCount = inputCount;
            this.outputItem = outputItem;
            this.outputCount = outputCount;
            this.sdmValue = sdmValue;
        }
    }

    public static class BinSettings {
        public final int updateDelayTicks;
        public final int inventoryRows;

        public BinSettings(int updateDelayTicks, int inventoryRows) {
            this.updateDelayTicks = updateDelayTicks;
            this.inventoryRows = inventoryRows;
        }
    }
}

